function setGUIPos

global guiInfo

guiInfo.IsNoteBookVers=0;

%MarkByHand
if guiInfo.IsNoteBookVers
  guiInfo.uiPos.MarkByHandFig=[50 50 600 500]; % NoteBook
  guiInfo.uiPos.MarkByHandFigXY=[50 50 600 500];
  guiInfo.uiPos.MarkByHandFigYZ=[50 50 600 500];
else
  guiInfo.uiPos.MarkByHandFig=[50 50 500 800]; % 22"  
  guiInfo.uiPos.MarkByHandFigYZ=[600 450 700 400];  
  guiInfo.uiPos.MarkByHandFigXY=[800 50  700 400];
end  

%FindSyn3D
if guiInfo.IsNoteBookVers
  guiInfo.uiPos.FindSyn3DFig=[20 50 700 400]; % NoteBook
  guiInfo.uiPos.FindSyn3DHistoErrorSynSizeFig=[50 50 500 500];
  guiInfo.uiPos.FindSyn3DHistoSynSizeFig=[50 50 500 500];
else
  guiInfo.uiPos.FindSyn3DFig=[20 50 700 400]; % 22"
  guiInfo.uiPos.FindSyn3DHistoErrorSynSizeFig=[50 50 500 500]; 
  guiInfo.uiPos.FindSyn3DHistoSynSizeFig=[50 50 500 500];
end  

% FindSyn3DautoThrLin
if guiInfo.IsNoteBookVers
  guiInfo.uiPos.FindSyn3DautoThrLinFig=[10 30 900 600]; % NoteBook
  guiInfo.uiPos.DoFindSyn3DautoThrLinBatchFig=[10 30 900 600];
else
  guiInfo.uiPos.FindSyn3DautoThrLinFig=[50 50 1300 900]; % 22"
  guiInfo.uiPos.DoFindSyn3DautoThrLinBatchFig=[30 30 800 900];
end  
  
%DoFindIntensity
if guiInfo.IsNoteBookVers
  guiInfo.uiPos.DoFindIntensityCalcSynFig=[50 10 900 700];  % NoteBook
  guiInfo.uiPos.DoFindIntensityCalcSynFWHMFig=[50 10 1400 950];
else
  guiInfo.uiPos.DoFindIntensityCalcSynFig=[50 70 800 500];  % 22"
  guiInfo.uiPos.DoFindIntensityCalcSynFWHMFig=[50 100 1200 700];
end  
  
%doShowYZ
if guiInfo.IsNoteBookVers
  guiInfo.uiPos.doShowYZ=[50 50 800 600]; % NoteBook
else
  guiInfo.uiPos.doShowYZ=[50 50 1000 900]; % 22"  
end

%DoSyn2Cell
if guiInfo.IsNoteBookVers
  guiInfo.uiPos.DoSyn2Cell=[100 40 600 600]; % NoteBook
else
  guiInfo.uiPos.DoSyn2Cell=[100 40 900 900]; % 22"  
end


%DoSynCellCalcVector
if guiInfo.IsNoteBookVers
  guiInfo.uiPos.DoSynCellCalcVectorCartesian=[100 40 600 600];  % NoteBook
  guiInfo.uiPos.DoSynCellCalcVectorCartesianPerCell=[150 40 600 600];
  guiInfo.uiPos.DoSynCellCalcVectorSpherical=[200 40 600 600]; 
  guiInfo.uiPos.DoSynCellCalcVectorCylindrical=[300 40 600 600]; 
else
  guiInfo.uiPos.DoSynCellCalcVectorCartesian=[200 40 900 900];  % 22"
  guiInfo.uiPos.DoSynCellCalcVectorCartesianPerCell=[250 40 900 900];  
  guiInfo.uiPos.DoSynCellCalcVectorSpherical=[300 40 900 900]; 
  guiInfo.uiPos.DoSynCellCalcVectorCylindrical=[400 40 1000 900]; 
end

%PlotOverviewFig
if guiInfo.IsNoteBookVers
  guiInfo.uiPos.DoPlotOverviewFig=[10 10 600 600]; % Notebook
else
  guiInfo.uiPos.DoPlotOverviewFig=[40 40 1280 900]; % 22"[  
end  

% 'Units','normalized',
guiInfo.PositionPicNucleusAv=  [0.0  0.65 0.32 0.32];
guiInfo.PositionPicSynapseAv=  [0.4  0.65 0.32 0.32];
guiInfo.PositionPicNucleus=    [0.0  0.325 0.32 0.32];
guiInfo.PositionPicSynapse=    [0.4  0.325 0.32 0.32];
guiInfo.PositionPicNucleusSeg= [0.0  0 0.32 0.32];
guiInfo.PositionPicSynapseSeg= [0.4  0 0.32 0.32];
guiInfo.PositionPicMembraneSeg=[0.75  0 0.2 0.32]; 

guiInfo.uiPos.Main.ListBoxInfo=   [0.82 0.76 0.16 0.21];
guiInfo.uiPos.Main.ListBoxResult= [0.82 0.52 0.16 0.22];
guiInfo.uiPos.Main.ListBoxProcessingStatus=[0.73 0.02 0.1 0.25];

guiInfo.isXpos=0.73;guiInfo.isDX=0.076; guiInfo.isYpos=0.96;guiInfo.isDY=0.022;
uiInfo.isYpos=guiInfo.isYpos-guiInfo.isDY-0.005; guiInfo.uiPos.Main.FileOpen=[guiInfo.isXpos guiInfo.isYpos guiInfo.isDX guiInfo.isDY];
guiInfo.isYpos=guiInfo.isYpos-guiInfo.isDY-0.005; guiInfo.uiPos.Main.DoSaveAll=[guiInfo.isXpos guiInfo.isYpos guiInfo.isDX guiInfo.isDY];
guiInfo.isYpos=guiInfo.isYpos-guiInfo.isDY-0.005; guiInfo.uiPos.Main.SaveAsXLS=[guiInfo.isXpos guiInfo.isYpos guiInfo.isDX guiInfo.isDY];

guiInfo.isYpos=guiInfo.isYpos-guiInfo.isDY-0.005; guiInfo.uiPos.Main.YZWindow=[guiInfo.isXpos guiInfo.isYpos guiInfo.isDX guiInfo.isDY];
guiInfo.isYpos=guiInfo.isYpos-guiInfo.isDY-0.005; guiInfo.uiPos.Main.MeasureWindow=[guiInfo.isXpos guiInfo.isYpos guiInfo.isDX guiInfo.isDY];

guiInfo.isYpos=guiInfo.isYpos-guiInfo.isDY-0.005; guiInfo.uiPos.Main.Syn2Cell=[guiInfo.isXpos guiInfo.isYpos guiInfo.isDX guiInfo.isDY];
guiInfo.isYpos=guiInfo.isYpos-guiInfo.isDY-0.005; guiInfo.uiPos.Main.Syn2CellCalcVector=[guiInfo.isXpos guiInfo.isYpos guiInfo.isDX guiInfo.isDY];
guiInfo.isYpos=guiInfo.isYpos-guiInfo.isDY-0.005; guiInfo.uiPos.Main.MarkByHand=[guiInfo.isXpos guiInfo.isYpos guiInfo.isDX guiInfo.isDY];
guiInfo.isYpos=guiInfo.isYpos-guiInfo.isDY-0.005; guiInfo.uiPos.Main.MeanDensity=[guiInfo.isXpos guiInfo.isYpos guiInfo.isDX guiInfo.isDY];

guiInfo.isYpos=guiInfo.isYpos-0.05; guiInfo.uiPos.Main.BackgroundModeMeanDensity=[guiInfo.isXpos+0.02 guiInfo.isYpos guiInfo.isDX-0.02 0.04];
guiInfo.isYpos=guiInfo.isYpos-0.05; guiInfo.uiPos.Main.ModeMeanDensity=[guiInfo.isXpos+0.02 guiInfo.isYpos guiInfo.isDX-0.02 0.04];

guiInfo.uiPos.Main.NucParam=[0.05 0.02 0.1 0.022];
guiInfo.uiPos.Main.DoCalcGauss=[0.2 0.02 0.1 0.022];

guiInfo.uiPos.Main.ListBoxNucleusChan=[0.3 0.32 0.05 0.06];
guiInfo.uiPos.Main.ListBoxSynapseChan=[0.68 0.32 0.05 0.06];

guiInfo.isXpos=0.94;guiInfo.isYpos=0.29;
guiInfo.uiPos.Main.ListBoxColocChanStr=      [guiInfo.isXpos guiInfo.isYpos 0.05 0.02];
guiInfo.uiPos.Main.ListBoxColocalisationChan=[guiInfo.isXpos guiInfo.isYpos-0.05 0.05 0.05];
guiInfo.uiPos.Main.Colocalisation=[guiInfo.isXpos-0.1 guiInfo.isYpos 0.07 0.02];
guiInfo.uiPos.Main.ColocMinDistStr=[guiInfo.isXpos-0.1 guiInfo.isYpos-0.03 0.07 0.017];
guiInfo.uiPos.Main.ColocMinDistStrXY=[guiInfo.isXpos-0.1 guiInfo.isYpos-0.05 0.03 0.017];
guiInfo.uiPos.Main.ColocMinDistStrZ=[guiInfo.isXpos-0.1 guiInfo.isYpos-0.07 0.03 0.017];
guiInfo.uiPos.Main.ColocMinDistXY=[guiInfo.isXpos-0.05 guiInfo.isYpos-0.05 0.03 0.017];
guiInfo.uiPos.Main.ColocMinDistZ=[guiInfo.isXpos-0.05 guiInfo.isYpos-0.07 0.03 0.017];
guiInfo.uiPos.Main.FrameColoc=[guiInfo.isXpos-0.105 0.215 0.16 0.10];

guiInfo.isXpos=0.82;guiInfo.isYpos=0.49;guiInfo.isDX=0.04;
guiInfo.uiPos.Main.ListBoxMeasureChanStr=[guiInfo.isXpos guiInfo.isYpos guiInfo.isDX 0.02];
guiInfo.uiPos.Main.ListBoxMeasureChan=[guiInfo.isXpos guiInfo.isYpos-0.06 guiInfo.isDX 0.06];
guiInfo.isXpos=0.87;
guiInfo.uiPos.Main.ListBoxProjChanStr=[guiInfo.isXpos guiInfo.isYpos guiInfo.isDX 0.02];
guiInfo.uiPos.Main.ListBoxProjChan=[guiInfo.isXpos guiInfo.isYpos-0.06 guiInfo.isDX 0.06];
guiInfo.isXpos=0.92;
guiInfo.uiPos.Main.ListBoxMembraneChanStr=[guiInfo.isXpos guiInfo.isYpos guiInfo.isDX 0.02];
guiInfo.uiPos.Main.ListBoxMembraneChan=[guiInfo.isXpos guiInfo.isYpos-0.06 guiInfo.isDX 0.06];

guiInfo.isXpos=0.32;guiInfo.isYpos=0.4;guiInfo.isDX=0.018;guiInfo.sliderLengthVert=0.18;
guiInfo.uiPos.Main.sliderPicNucleusMin=[guiInfo.isXpos guiInfo.isYpos guiInfo.isDX guiInfo.sliderLengthVert];
guiInfo.uiPos.Main.sliderPicTextNucleusMin=[guiInfo.isXpos guiInfo.isYpos+guiInfo.sliderLengthVert guiInfo.isDX 0.018];
guiInfo.uiPos.Main.sliderPicNucleusMax=[guiInfo.isXpos+guiInfo.isDX guiInfo.isYpos guiInfo.isDX guiInfo.sliderLengthVert];
guiInfo.uiPos.Main.sliderPicTextNucleusMax=[guiInfo.isXpos+guiInfo.isDX guiInfo.isYpos+guiInfo.sliderLengthVert guiInfo.isDX 0.018];
guiInfo.uiPos.Main.sliderPicNucleusMinMaxStr=[guiInfo.isXpos guiInfo.isYpos+guiInfo.sliderLengthVert+0.02 2*guiInfo.isDX 0.018];

guiInfo.isXpos=0.11;guiInfo.isYpos=0.34;guiInfo.isDY=0.018;guiInfo.sliderLengthHorz=0.13;
guiInfo.uiPos.Main.sliderPicNucleusStr=[guiInfo.isXpos-0.04 guiInfo.isYpos 0.04 guiInfo.isDY];
guiInfo.uiPos.Main.sliderPicNucleus=[guiInfo.isXpos guiInfo.isYpos guiInfo.sliderLengthHorz guiInfo.isDY];
guiInfo.uiPos.Main.sliderPicTextNucleus=[guiInfo.isXpos+guiInfo.sliderLengthHorz+0.01 guiInfo.isYpos 0.04 guiInfo.isDY];
guiInfo.uiPos.Main.thresholdNucl=[guiInfo.isXpos guiInfo.isYpos-guiInfo.isDY guiInfo.sliderLengthHorz guiInfo.isDY];
guiInfo.uiPos.Main.thresholdNuclText=[guiInfo.isXpos+guiInfo.sliderLengthHorz+0.01 guiInfo.isYpos-guiInfo.isDY 0.04 guiInfo.isDY];
guiInfo.uiPos.Main.thresholdNuclStr=[guiInfo.isXpos-0.04 guiInfo.isYpos-guiInfo.isDY 0.04 guiInfo.isDY];
guiInfo.uiPos.Main.CheckboxNucProj=[guiInfo.isXpos-0.1 guiInfo.isYpos 0.06 guiInfo.isDY];

guiInfo.isXpos=0.49;guiInfo.isYpos=0.34;guiInfo.isDY=0.018;guiInfo.sliderLengthHorz=0.13;
guiInfo.uiPos.Main.sliderPicSynapse=[guiInfo.isXpos guiInfo.isYpos guiInfo.sliderLengthHorz guiInfo.isDY];
guiInfo.uiPos.Main.sliderPicTextSynapse=[guiInfo.isXpos+guiInfo.sliderLengthHorz+0.01 guiInfo.isYpos 0.04 guiInfo.isDY];
guiInfo.uiPos.Main.sliderPicSynapseStr=[guiInfo.isXpos-0.04 guiInfo.isYpos 0.04 guiInfo.isDY];
guiInfo.uiPos.Main.thresholdSyn=[guiInfo.isXpos guiInfo.isYpos-guiInfo.isDY guiInfo.sliderLengthHorz guiInfo.isDY];
guiInfo.uiPos.Main.thresholdSynText=[guiInfo.isXpos+guiInfo.sliderLengthHorz+0.01 guiInfo.isYpos-guiInfo.isDY 0.04 guiInfo.isDY];
guiInfo.uiPos.Main.thresholdSynStr=[guiInfo.isXpos-0.04 guiInfo.isYpos-guiInfo.isDY 0.04 guiInfo.isDY];
guiInfo.uiPos.Main.CheckboxSynProj=[guiInfo.isXpos-0.1 guiInfo.isYpos 0.06 guiInfo.isDY];
guiInfo.uiPos.Main.SetRoiSyn=[guiInfo.isXpos-0.1 guiInfo.isYpos-0.03 0.06 guiInfo.isDY];
guiInfo.uiPos.Main.DelRoiSyn=[guiInfo.isXpos-0.1 guiInfo.isYpos-0.05 0.06 guiInfo.isDY];
guiInfo.uiPos.Main.UpdateRoiSyn=[guiInfo.isXpos-0.1 guiInfo.isYpos-0.07 0.06 guiInfo.isDY];

guiInfo.uiPos.Main.ZStackRangeStr=[guiInfo.isXpos-0.04 guiInfo.isYpos+guiInfo.isDY 0.04 guiInfo.isDY];
guiInfo.uiPos.Main.ZStackMin=[guiInfo.isXpos+guiInfo.sliderLengthHorz/2-0.05 guiInfo.isYpos+guiInfo.isDY 0.04 guiInfo.isDY];
guiInfo.uiPos.Main.ZStackMax=[guiInfo.isXpos+guiInfo.sliderLengthHorz/2+0.01 guiInfo.isYpos+guiInfo.isDY 0.04 guiInfo.isDY];

guiInfo.isXpos=0.72;guiInfo.isYpos=0.4;guiInfo.isDX=0.018;guiInfo.sliderLengthVert=0.18;
guiInfo.uiPos.Main.sliderPicSynapseMin=[guiInfo.isXpos guiInfo.isYpos guiInfo.isDX guiInfo.sliderLengthVert];
guiInfo.uiPos.Main.sliderPicTextSynapseMin=[guiInfo.isXpos guiInfo.isYpos+guiInfo.sliderLengthVert guiInfo.isDX 0.018];
guiInfo.uiPos.Main.sliderPicSynapseMax=[guiInfo.isXpos+guiInfo.isDX guiInfo.isYpos guiInfo.isDX guiInfo.sliderLengthVert];
guiInfo.uiPos.Main.sliderPicTextSynapseMax=[guiInfo.isXpos+guiInfo.isDX guiInfo.isYpos+guiInfo.sliderLengthVert guiInfo.isDX 0.018];
guiInfo.uiPos.Main.sliderPicSynapseMinMaxStr=[guiInfo.isXpos guiInfo.isYpos+guiInfo.sliderLengthVert+0.02 2*guiInfo.isDX 0.018];
guiInfo.uiPos.Main.sliderPicSynapseLeft=[guiInfo.isXpos+2*guiInfo.isDX guiInfo.isYpos guiInfo.isDX guiInfo.sliderLengthVert];
guiInfo.uiPos.Main.sliderPicTextSynapseLeft=[guiInfo.isXpos+2*guiInfo.isDX guiInfo.isYpos+guiInfo.sliderLengthVert guiInfo.isDX 0.018];
guiInfo.uiPos.Main.sliderPicSynapseRight=[guiInfo.isXpos+3*guiInfo.isDX guiInfo.isYpos guiInfo.isDX guiInfo.sliderLengthVert];
guiInfo.uiPos.Main.sliderPicTextSynapseRight=[guiInfo.isXpos+3*guiInfo.isDX guiInfo.isYpos+guiInfo.sliderLengthVert guiInfo.isDX 0.018];
guiInfo.uiPos.Main.sliderPicSynapseLeftRightStr=[guiInfo.isXpos+2*guiInfo.isDX guiInfo.isYpos+guiInfo.sliderLengthVert+0.02 2*guiInfo.isDX 0.018];

guiInfo.isXpos=0.84;guiInfo.isYpos=0.105;isDY=0.025;isDX=0.09;
guiInfo.uiPos.Main.DoSynapse3D=[guiInfo.isXpos guiInfo.isYpos+3*isDY 0.07 0.02];
guiInfo.uiPos.Main.DoSynapse3DthrLin=[guiInfo.isXpos guiInfo.isYpos+2*isDY 0.07 0.02];
guiInfo.uiPos.Main.ThresholdStepStr=[guiInfo.isXpos guiInfo.isYpos+isDY-0.005 0.07 0.02];
guiInfo.uiPos.Main.ThresholdStep=[guiInfo.isXpos guiInfo.isYpos 0.07 0.02];
guiInfo.uiPos.Main.MaxSynapseSizeStr=[guiInfo.isXpos+isDX guiInfo.isYpos+3*isDY 0.06 0.02];
guiInfo.uiPos.Main.MaxSynapseSize=[guiInfo.isXpos+isDX guiInfo.isYpos+2*isDY 0.06 0.02];
guiInfo.uiPos.Main.MinSynapseSizeStr=[guiInfo.isXpos+isDX guiInfo.isYpos+isDY 0.06 0.02];
guiInfo.uiPos.Main.MinSynapseSize=[guiInfo.isXpos+isDX guiInfo.isYpos 0.06 0.02];
guiInfo.uiPos.Main.FrameSynCalc=[guiInfo.isXpos-0.005 guiInfo.isYpos-0.005 0.16 0.105];

guiInfo.isXpos=0.84;guiInfo.isYpos=0.05;isDY=0.024;isDX=0.09;
guiInfo.uiPos.Main.DoIntensity=[guiInfo.isXpos guiInfo.isYpos 0.07 0.02];
guiInfo.uiPos.Main.MinusBackGroundStr=[guiInfo.isXpos guiInfo.isYpos-isDY 0.07 0.02];
guiInfo.uiPos.Main.CheckboxFWHM=[guiInfo.isXpos guiInfo.isYpos-2*isDY 0.07 0.02];
guiInfo.uiPos.Main.BackgroundMode=[guiInfo.isXpos+isDX guiInfo.isYpos-0.03 0.06 0.05];
guiInfo.uiPos.Main.FrameIntensity=[guiInfo.isXpos-0.005 0.00 0.16 0.08];


guiInfo.isXpos=0.4;guiInfo.isYpos=0.01;isDY=0.025; isDX=0.09;
guiInfo.uiPos.Main.EliminateRegionsSmallerSynStr=[guiInfo.isXpos guiInfo.isYpos 0.09 0.02];
guiInfo.uiPos.Main.EliminateRegionsSmallerSyn=[guiInfo.isXpos+0.09 guiInfo.isYpos 0.03 0.02];
guiInfo.uiPos.Main.NrSyn2DStr=[guiInfo.isXpos+0.16 guiInfo.isYpos 0.04 0.02];
guiInfo.uiPos.Main.NrSyn2D=[guiInfo.isXpos+0.20 guiInfo.isYpos 0.03 0.02];

guiInfo.isXpos=0.84;guiInfo.isYpos=0.335;isDY=0.025;isDX=0.08;
guiInfo.uiPos.Main.ErrROI=[guiInfo.isXpos-0.005 0.325 0.16 0.09];
guiInfo.uiPos.Main.ErrorDXStr=[guiInfo.isXpos guiInfo.isYpos 0.04 0.02];
guiInfo.uiPos.Main.ErrorDYStr=[guiInfo.isXpos guiInfo.isYpos+isDY 0.04 0.02];
guiInfo.uiPos.Main.ErrorDZStr=[guiInfo.isXpos guiInfo.isYpos+2*isDY 0.04 0.02];
guiInfo.uiPos.Main.ErrorDX=[guiInfo.isXpos+0.04 guiInfo.isYpos 0.03 0.02];
guiInfo.uiPos.Main.ErrorDY=[guiInfo.isXpos+0.04 guiInfo.isYpos+isDY 0.03 0.02];
guiInfo.uiPos.Main.ErrorDZ=[guiInfo.isXpos+0.04 guiInfo.isYpos+2*isDY 0.03 0.02];
guiInfo.uiPos.Main.roiProjRangeXStr=[guiInfo.isXpos+isDX guiInfo.isYpos 0.04 0.02];
guiInfo.uiPos.Main.roiProjRangeYStr=[guiInfo.isXpos+isDX guiInfo.isYpos+isDY 0.04 0.02];
guiInfo.uiPos.Main.roiProjRangeZStr=[guiInfo.isXpos+isDX guiInfo.isYpos+2*isDY 0.04 0.02];
guiInfo.uiPos.Main.roiProjRangeX=[guiInfo.isXpos+isDX+0.04 guiInfo.isYpos 0.03 0.02];
guiInfo.uiPos.Main.roiProjRangeY=[guiInfo.isXpos+isDX+0.04 guiInfo.isYpos+isDY 0.03 0.02];
guiInfo.uiPos.Main.roiProjRangeZ=[guiInfo.isXpos+isDX+0.04 guiInfo.isYpos+2*isDY 0.03 0.02];

%  <) measure Cell   NucCytoProjMeasure
guiInfo.uiPos.MeasureNuc.doPosYZ=[0.15  0.25 0.16  0.6];
guiInfo.uiPos.MeasureNuc.doPosXY=[0.35  0.2 0.58  0.3];
guiInfo.uiPos.MeasureNuc.doPosXZ=[0.35  0.65 0.58  0.25];

guiInfo.isXpos=0.01;guiInfo.isYpos=0.02;
guiInfo.uiPos.MeasureNuc.ListBoxMeasureCell=[guiInfo.isXpos guiInfo.isYpos 0.05 0.2];
guiInfo.isYpos=0.25;isDY=0.025;
guiInfo.isYpos=guiInfo.isYpos+isDY;guiInfo.uiPos.MeasureNuc.CheckboxAngle2Nucleus=[guiInfo.isXpos guiInfo.isYpos 0.08 0.02];
guiInfo.isYpos=guiInfo.isYpos+isDY;guiInfo.uiPos.MeasureNuc.CheckboxAngleBySlope=[guiInfo.isXpos guiInfo.isYpos 0.08 0.02];
guiInfo.isYpos=guiInfo.isYpos+isDY;guiInfo.uiPos.MeasureNuc.CheckboxHorzMeanByShape=[guiInfo.isXpos guiInfo.isYpos 0.08 0.02];
guiInfo.isYpos=guiInfo.isYpos+isDY;guiInfo.uiPos.MeasureNuc.CheckboxVertMeanByShape=[guiInfo.isXpos guiInfo.isYpos 0.08 0.02];

guiInfo.isYpos=0.4;
guiInfo.uiPos.MeasureNuc.MeasureDistInfo=[guiInfo.isXpos guiInfo.isYpos 0.05 0.02];
guiInfo.uiPos.MeasureNuc.MeasureDistTxt=[guiInfo.isXpos+0.05 guiInfo.isYpos 0.03 0.02];
guiInfo.isYpos=0.44;
guiInfo.uiPos.MeasureNuc.MeasureMarkZInfo=[guiInfo.isXpos guiInfo.isYpos 0.05 0.02];
guiInfo.uiPos.MeasureNuc.MeasureMarkZTxt=[guiInfo.isXpos+0.05 guiInfo.isYpos 0.03 0.02];
guiInfo.isYpos=0.48;
guiInfo.uiPos.MeasureNuc.ListBoxGraficMode=[guiInfo.isXpos guiInfo.isYpos 0.05 0.06];

guiInfo.isXpos=0.16;guiInfo.isYpos=0.02;guiInfo.isDX=0.03;guiInfo.isDXInfo=0.06;guiInfo.isDY=0.02;guiInfo.isDYstep=0.023;guiInfo.sliderLengthHorz=0.17;
guiInfo.uiPos.MeasureNuc.sliderpicMeasureYZNuclOffs=[guiInfo.isXpos guiInfo.isYpos guiInfo.sliderLengthHorz guiInfo.isDY];
guiInfo.uiPos.MeasureNuc.MeasureYZNuclOffsTXTinfo=[guiInfo.isXpos-guiInfo.isDXInfo guiInfo.isYpos guiInfo.isDXInfo guiInfo.isDY];
guiInfo.uiPos.MeasureNuc.MeasureYZNuclOffsTXT=[guiInfo.isXpos+guiInfo.sliderLengthHorz guiInfo.isYpos guiInfo.isDX guiInfo.isDY];
guiInfo.isYpos=guiInfo.isYpos+guiInfo.isDYstep;
guiInfo.uiPos.MeasureNuc.sliderpicMeasureYZAngleA=[guiInfo.isXpos guiInfo.isYpos guiInfo.sliderLengthHorz guiInfo.isDY];
guiInfo.uiPos.MeasureNuc.MeasureYZAngleATXTinfo=[guiInfo.isXpos-guiInfo.isDXInfo guiInfo.isYpos guiInfo.isDXInfo guiInfo.isDY];
guiInfo.uiPos.MeasureNuc.MeasureYZAngleATXT=[guiInfo.isXpos+guiInfo.sliderLengthHorz guiInfo.isYpos guiInfo.isDX guiInfo.isDY];
guiInfo.isYpos=guiInfo.isYpos+guiInfo.isDYstep;
guiInfo.uiPos.MeasureNuc.sliderpicMeasureYZAngleOffsA=[guiInfo.isXpos guiInfo.isYpos guiInfo.sliderLengthHorz guiInfo.isDY];
guiInfo.uiPos.MeasureNuc.MeasureYZAngleOffsATXTinfo=[guiInfo.isXpos-guiInfo.isDXInfo guiInfo.isYpos guiInfo.isDXInfo guiInfo.isDY];
guiInfo.uiPos.MeasureNuc.MeasureYZAngleOffsATXT=[guiInfo.isXpos+guiInfo.sliderLengthHorz guiInfo.isYpos guiInfo.isDX guiInfo.isDY];
guiInfo.isYpos=guiInfo.isYpos+guiInfo.isDYstep;
guiInfo.uiPos.MeasureNuc.sliderpicMeasureYZAngleB=[guiInfo.isXpos guiInfo.isYpos guiInfo.sliderLengthHorz guiInfo.isDY];
guiInfo.uiPos.MeasureNuc.MeasureYZAngleBTXTinfo=[guiInfo.isXpos-guiInfo.isDXInfo guiInfo.isYpos guiInfo.isDXInfo guiInfo.isDY];
guiInfo.uiPos.MeasureNuc.MeasureYZAngleBTXT=[guiInfo.isXpos+guiInfo.sliderLengthHorz guiInfo.isYpos guiInfo.isDX guiInfo.isDY];
guiInfo.isYpos=guiInfo.isYpos+guiInfo.isDYstep;
guiInfo.uiPos.MeasureNuc.sliderpicMeasureYZAngleOffsB=[guiInfo.isXpos guiInfo.isYpos guiInfo.sliderLengthHorz guiInfo.isDY];
guiInfo.uiPos.MeasureNuc.MeasureYZAngleOffsBTXTinfo=[guiInfo.isXpos-guiInfo.isDXInfo guiInfo.isYpos guiInfo.isDXInfo guiInfo.isDY];
guiInfo.uiPos.MeasureNuc.MeasureYZAngleOffsBTXT=[guiInfo.isXpos+guiInfo.sliderLengthHorz guiInfo.isYpos guiInfo.isDX guiInfo.isDY];
guiInfo.isYpos=guiInfo.isYpos+guiInfo.isDYstep;
guiInfo.uiPos.MeasureNuc.sliderpicMeasureYZAngleC=[guiInfo.isXpos guiInfo.isYpos guiInfo.sliderLengthHorz guiInfo.isDY];
guiInfo.uiPos.MeasureNuc.MeasureYZAngleCTXTinfo=[guiInfo.isXpos-guiInfo.isDXInfo guiInfo.isYpos guiInfo.isDXInfo guiInfo.isDY];
guiInfo.uiPos.MeasureNuc.MeasureYZAngleCTXT=[guiInfo.isXpos+guiInfo.sliderLengthHorz guiInfo.isYpos guiInfo.isDX guiInfo.isDY];
guiInfo.isYpos=guiInfo.isYpos+guiInfo.isDYstep;
guiInfo.uiPos.MeasureNuc.sliderpicMeasureYZAngleOffsC=[guiInfo.isXpos guiInfo.isYpos guiInfo.sliderLengthHorz guiInfo.isDY];
guiInfo.uiPos.MeasureNuc.MeasureYZAngleOffsCTXTinfo=[guiInfo.isXpos-guiInfo.isDXInfo guiInfo.isYpos guiInfo.isDXInfo guiInfo.isDY];
guiInfo.uiPos.MeasureNuc.MeasureYZAngleOffsCTXT=[guiInfo.isXpos+guiInfo.sliderLengthHorz guiInfo.isYpos guiInfo.isDX guiInfo.isDY];
guiInfo.isYpos=guiInfo.isYpos+guiInfo.isDYstep;
guiInfo.uiPos.MeasureNuc.sliderpicMeasureYZHorzA=[guiInfo.isXpos guiInfo.isYpos guiInfo.sliderLengthHorz guiInfo.isDY];
guiInfo.uiPos.MeasureNuc.sliderpicMeasureYZHorzATXTinfo=[guiInfo.isXpos-guiInfo.isDXInfo guiInfo.isYpos guiInfo.isDXInfo guiInfo.isDY];
guiInfo.uiPos.MeasureNuc.MeasureYZHorzATXT=[guiInfo.isXpos+guiInfo.sliderLengthHorz guiInfo.isYpos guiInfo.isDX guiInfo.isDY];
guiInfo.isYpos=guiInfo.isYpos+guiInfo.isDYstep;
guiInfo.uiPos.MeasureNuc.sliderpicMeasureYZHorzB=[guiInfo.isXpos guiInfo.isYpos guiInfo.sliderLengthHorz guiInfo.isDY];
guiInfo.uiPos.MeasureNuc.sliderpicMeasureYZHorzBTXTinfo=[guiInfo.isXpos-guiInfo.isDXInfo guiInfo.isYpos guiInfo.isDXInfo guiInfo.isDY];
guiInfo.uiPos.MeasureNuc.MeasureYZHorzBTXT=[guiInfo.isXpos+guiInfo.sliderLengthHorz guiInfo.isYpos guiInfo.isDX guiInfo.isDY];
guiInfo.isYpos=guiInfo.isYpos+guiInfo.isDYstep;
guiInfo.uiPos.MeasureNuc.sliderpicMeasureYZVertA=[guiInfo.isXpos guiInfo.isYpos guiInfo.sliderLengthHorz guiInfo.isDY];
guiInfo.uiPos.MeasureNuc.sliderpicMeasureYZVertATXTinfo=[guiInfo.isXpos-guiInfo.isDXInfo guiInfo.isYpos guiInfo.isDXInfo guiInfo.isDY];
guiInfo.uiPos.MeasureNuc.MeasureYZVertATXT=[guiInfo.isXpos+guiInfo.sliderLengthHorz guiInfo.isYpos guiInfo.isDX guiInfo.isDY];
guiInfo.isYpos=guiInfo.isYpos+guiInfo.isDYstep;
guiInfo.uiPos.MeasureNuc.sliderpicMeasureYZVertB=[guiInfo.isXpos guiInfo.isYpos guiInfo.sliderLengthHorz guiInfo.isDY];
guiInfo.uiPos.MeasureNuc.sliderpicMeasureYZVertBTXTinfo=[guiInfo.isXpos-guiInfo.isDXInfo guiInfo.isYpos guiInfo.isDXInfo guiInfo.isDY];
guiInfo.uiPos.MeasureNuc.MeasureYZVertBTXT=[guiInfo.isXpos+guiInfo.sliderLengthHorz guiInfo.isYpos guiInfo.isDX guiInfo.isDY];

guiInfo.isXpos=0.5;guiInfo.isYpos=0.02;
guiInfo.uiPos.MeasureNuc.sliderpicMeasureXYAngleA=[guiInfo.isXpos guiInfo.isYpos guiInfo.sliderLengthHorz guiInfo.isDY];
guiInfo.uiPos.MeasureNuc.MeasureXYAngleATXTinfo=[guiInfo.isXpos-guiInfo.isDXInfo guiInfo.isYpos guiInfo.isDXInfo guiInfo.isDY];
guiInfo.uiPos.MeasureNuc.MeasureXYAngleATXT=[guiInfo.isXpos+guiInfo.sliderLengthHorz guiInfo.isYpos guiInfo.isDX guiInfo.isDY];
guiInfo.isYpos=guiInfo.isYpos+guiInfo.isDYstep;
guiInfo.uiPos.MeasureNuc.sliderpicMeasureXYAngleOffsA=[guiInfo.isXpos guiInfo.isYpos guiInfo.sliderLengthHorz guiInfo.isDY];
guiInfo.uiPos.MeasureNuc.MeasureXYAngleOffsATXTinfo=[guiInfo.isXpos-guiInfo.isDXInfo guiInfo.isYpos guiInfo.isDXInfo guiInfo.isDY];
guiInfo.uiPos.MeasureNuc.MeasureXYAngleOffsATXT=[guiInfo.isXpos+guiInfo.sliderLengthHorz guiInfo.isYpos guiInfo.isDX guiInfo.isDY];
guiInfo.isYpos=guiInfo.isYpos+guiInfo.isDYstep;
guiInfo.uiPos.MeasureNuc.sliderpicMeasureXYHorzA=[guiInfo.isXpos guiInfo.isYpos guiInfo.sliderLengthHorz guiInfo.isDY];
guiInfo.uiPos.MeasureNuc.sliderpicMeasureXYHorzATXTinfo=[guiInfo.isXpos-guiInfo.isDXInfo guiInfo.isYpos guiInfo.isDXInfo guiInfo.isDY];
guiInfo.uiPos.MeasureNuc.MeasureXYHorzATXT=[guiInfo.isXpos+guiInfo.sliderLengthHorz guiInfo.isYpos guiInfo.isDX guiInfo.isDY];
guiInfo.isYpos=guiInfo.isYpos+guiInfo.isDYstep;
guiInfo.uiPos.MeasureNuc.sliderpicMeasureXYHorzB=[guiInfo.isXpos guiInfo.isYpos guiInfo.sliderLengthHorz guiInfo.isDY];
guiInfo.uiPos.MeasureNuc.sliderpicMeasureXYHorzBTXTinfo=[guiInfo.isXpos-guiInfo.isDXInfo guiInfo.isYpos guiInfo.isDXInfo guiInfo.isDY];
guiInfo.uiPos.MeasureNuc.MeasureXYHorzBTXT=[guiInfo.isXpos+guiInfo.sliderLengthHorz guiInfo.isYpos guiInfo.isDX guiInfo.isDY];
guiInfo.isYpos=guiInfo.isYpos+guiInfo.isDYstep;
guiInfo.uiPos.MeasureNuc.sliderpicMeasureXYHorzC=[guiInfo.isXpos guiInfo.isYpos guiInfo.sliderLengthHorz guiInfo.isDY];
guiInfo.uiPos.MeasureNuc.sliderpicMeasureXYHorzCTXTinfo=[guiInfo.isXpos-guiInfo.isDXInfo guiInfo.isYpos guiInfo.isDXInfo guiInfo.isDY];
guiInfo.uiPos.MeasureNuc.MeasureXYHorzCTXT=[guiInfo.isXpos+guiInfo.sliderLengthHorz guiInfo.isYpos guiInfo.isDX guiInfo.isDY];
guiInfo.isYpos=guiInfo.isYpos+guiInfo.isDYstep;
guiInfo.uiPos.MeasureNuc.sliderpicMeasureXYVertA=[guiInfo.isXpos guiInfo.isYpos guiInfo.sliderLengthHorz guiInfo.isDY];
guiInfo.uiPos.MeasureNuc.sliderpicMeasureXYVertATXTinfo=[guiInfo.isXpos-guiInfo.isDXInfo guiInfo.isYpos guiInfo.isDXInfo guiInfo.isDY];
guiInfo.uiPos.MeasureNuc.MeasureXYVertATXT=[guiInfo.isXpos+guiInfo.sliderLengthHorz guiInfo.isYpos guiInfo.isDX guiInfo.isDY];
guiInfo.isYpos=guiInfo.isYpos+guiInfo.isDYstep;
guiInfo.uiPos.MeasureNuc.sliderpicMeasureXYVertB=[guiInfo.isXpos guiInfo.isYpos guiInfo.sliderLengthHorz guiInfo.isDY];
guiInfo.uiPos.MeasureNuc.sliderpicMeasureXYVertBTXTinfo=[guiInfo.isXpos-guiInfo.isDXInfo guiInfo.isYpos guiInfo.isDXInfo guiInfo.isDY];
guiInfo.uiPos.MeasureNuc.MeasureXYVertBTXT=[guiInfo.isXpos+guiInfo.sliderLengthHorz guiInfo.isYpos guiInfo.isDX guiInfo.isDY];
guiInfo.isYpos=guiInfo.isYpos+guiInfo.isDYstep;
guiInfo.uiPos.MeasureNuc.DeleteRoiMeasureNucCytoProj=[guiInfo.isXpos-(guiInfo.sliderLengthHorz/5) guiInfo.isYpos 0.05 guiInfo.isDY];
guiInfo.uiPos.MeasureNuc.UpdateRoiMeasureNucCytoProj=[guiInfo.isXpos+(guiInfo.sliderLengthHorz/5) guiInfo.isYpos 0.05 guiInfo.isDY];
guiInfo.uiPos.MeasureNuc.SetRoiMeasureNucCytoProj=[guiInfo.isXpos+(guiInfo.sliderLengthHorz/2) guiInfo.isYpos 0.05 guiInfo.isDY];

guiInfo.isXpos=0.5;guiInfo.isYpos=0.55;
guiInfo.uiPos.MeasureNuc.sliderpicMeasureXZAngleA=[guiInfo.isXpos guiInfo.isYpos guiInfo.sliderLengthHorz guiInfo.isDY];
guiInfo.uiPos.MeasureNuc.MeasureXZAngleATXTinfo=[guiInfo.isXpos-guiInfo.isDXInfo guiInfo.isYpos guiInfo.isDXInfo guiInfo.isDY];
guiInfo.uiPos.MeasureNuc.MeasureXZAngleATXT=[guiInfo.isXpos+guiInfo.sliderLengthHorz guiInfo.isYpos guiInfo.isDX guiInfo.isDY];
guiInfo.isYpos=guiInfo.isYpos+guiInfo.isDYstep;
guiInfo.uiPos.MeasureNuc.sliderpicMeasureXZAngleOffsA=[guiInfo.isXpos guiInfo.isYpos guiInfo.sliderLengthHorz guiInfo.isDY];
guiInfo.uiPos.MeasureNuc.MeasureXZAngleOffsATXTinfo=[guiInfo.isXpos-guiInfo.isDXInfo guiInfo.isYpos guiInfo.isDXInfo guiInfo.isDY];
guiInfo.uiPos.MeasureNuc.MeasureXZAngleOffsATXT=[guiInfo.isXpos+guiInfo.sliderLengthHorz guiInfo.isYpos guiInfo.isDX guiInfo.isDY];


% MarkByHand

guiInfo.isYpos=0.02;guiInfo.sliderLengthHorz=0.2; guiInfo.dX=0.15;

guiInfo.uiPos.MarkByHand.MeasureByHandClearAll=[0.03 guiInfo.isYpos guiInfo.dX 0.03];
guiInfo.uiPos.MarkByHand.MeasureByHandClear=[0.2 guiInfo.isYpos guiInfo.dX 0.03];
guiInfo.uiPos.MarkByHand.MeasureByHandLoad=[0.37 guiInfo.isYpos guiInfo.dX 0.03];

guiInfo.uiPos.MarkByHand.MeasureByHandSynProj=[0.55 guiInfo.isYpos guiInfo.dX 0.02];
guiInfo.uiPos.MarkByHand.MeasureByHandPicZ=[0.55+guiInfo.dX guiInfo.isYpos guiInfo.sliderLengthHorz 0.02];
guiInfo.uiPos.MarkByHand.MeasureByHandPicZText=[0.55+guiInfo.dX+guiInfo.sliderLengthHorz guiInfo.isYpos 0.05 0.02];

guiInfo.uiPos.MarkByHand.MeasureByHandLoadChan=[0.03 0.7 guiInfo.dX 0.09];
guiInfo.uiPos.MarkByHand.MeasureByHandLoadNrSyn=[0.03 0.8 guiInfo.dX 0.02];

guiInfo.uiPos.MarkByHand.MeasureByHandSynRef=    [0.3  0.8 guiInfo.dX 0.02];
guiInfo.uiPos.MarkByHand.MeasureByHandSynRefNr=  [0.48 0.8 0.08  0.02];
guiInfo.uiPos.MarkByHand.MeasureByHandChanSynRef =[0.3 0.7 guiInfo.dX 0.09];
guiInfo.uiPos.MarkByHand.MeasureByHandDoSynRefROI=[0.48 0.7 guiInfo.dX 0.03];
guiInfo.uiPos.MarkByHand.MeasureByHandSynRefROIdist=[0.48 0.74 0.08 0.02];

guiInfo.uiPos.MarkByHand.ListBoxMeasureByHand=[0.03 0.08 0.6 0.6];

guiInfo.uiPos.MarkByHand.MeasureByHandSave=[0.8 0.95 guiInfo.dX 0.03];
guiInfo.uiPos.MarkByHand.MeasureByHandSingle=[0.06 0.85 guiInfo.dX 0.03];
guiInfo.uiPos.MarkByHand.MeasureByHandBatch=[0.06+guiInfo.dX 0.85 guiInfo.dX 0.03];

guiInfo.uiPos.MarkByHand.MeasureByHandGraficMode=[0.8 0.85 guiInfo.dX 0.08];

guiInfo.uiPos.MarkByHand.MeasureByHandAddCalcCenter=[0.5 0.85 guiInfo.dX 0.02];
guiInfo.uiPos.MarkByHand.roiX=   [0.50 0.80 0.06 0.02];
guiInfo.uiPos.MarkByHand.roiXStr=[0.57 0.80 0.10 0.02];
guiInfo.uiPos.MarkByHand.roiY=   [0.50 0.76 0.06 0.02];
guiInfo.uiPos.MarkByHand.roiYStr=[0.57 0.76 0.10 0.02];
guiInfo.uiPos.MarkByHand.roiZ=   [0.50 0.72 0.06 0.02];
guiInfo.uiPos.MarkByHand.roiZStr=[0.57 0.72 0.10 0.02];

guiInfo.uiPos.MarkByHand.MeasureByHandInputMode= [0.7 0.6 0.06 0.1];
guiInfo.uiPos.MarkByHand.MeasureByHandSyn2CellNr=[0.7 0.55 0.04 0.1];

guiInfo.uiPos.MarkByHand.MeasureByHandCalIntensROI=[0.8 0.68 0.19 0.02];
for ii=1:4 
  guiInfo.uiPos.MarkByHand.MeasureByHandRef(ii).ispos=            [0.8 0.7-(ii*0.14) guiInfo.dX 0.1 ];
  guiInfo.uiPos.MarkByHand.MeasureByHandRefText(ii).ispos=        [0.8 0.68-(ii*0.14)   0.04    0.02];
  guiInfo.uiPos.MarkByHand.MeasureByHandCalIntensSlider(ii).ispos=[0.85 0.68-(ii*0.14)  0.15    0.02];
end;


% FindSyn3DautoThrLin
guiInfo.isXpos=0.01;guiInfo.isYpos=0.05;guiInfo.sliderLengthVert=0.3;guiInfo.isDX=0.03;
guiInfo.uiPos.FindSyn3DautoThrLin.DoSynapse3DthrLinChangeParam1=[guiInfo.isXpos guiInfo.isYpos guiInfo.isDX guiInfo.sliderLengthVert];
guiInfo.uiPos.FindSyn3DautoThrLin.DoSynapse3DthrLinChangeParam1Text=[guiInfo.isXpos guiInfo.isYpos-0.02 guiInfo.isDX 0.02];
guiInfo.uiPos.FindSyn3DautoThrLin.DoSynapse3DthrLinChangeParam1Str=[guiInfo.isXpos guiInfo.isYpos+guiInfo.sliderLengthVert guiInfo.isDX 0.02];
guiInfo.isXpos=0.05;
guiInfo.uiPos.FindSyn3DautoThrLin.DoSynapse3DthrLinChangeParam2=[guiInfo.isXpos guiInfo.isYpos guiInfo.isDX guiInfo.sliderLengthVert];
guiInfo.uiPos.FindSyn3DautoThrLin.DoSynapse3DthrLinChangeParam2Text=[guiInfo.isXpos guiInfo.isYpos-0.02 guiInfo.isDX 0.02];
guiInfo.uiPos.FindSyn3DautoThrLin.DoSynapse3DthrLinChangeParam2Str=[guiInfo.isXpos guiInfo.isYpos+guiInfo.sliderLengthVert guiInfo.isDX 0.02];

guiInfo.isXpos=0.05;guiInfo.isYpos=0.5;
guiInfo.uiPos.FindSyn3DautoThrLin.DoSynapse3DthrLinChangeParam3=[guiInfo.isXpos guiInfo.isYpos guiInfo.isDX guiInfo.sliderLengthVert];
guiInfo.uiPos.FindSyn3DautoThrLin.DoSynapse3DthrLinChangeParam3Text=[guiInfo.isXpos guiInfo.isYpos-0.02 guiInfo.isDX 0.02];
guiInfo.uiPos.FindSyn3DautoThrLin.DoSynapse3DthrLinChangeParam3Str=[guiInfo.isXpos guiInfo.isYpos+guiInfo.sliderLengthVert guiInfo.isDX 0.02];
guiInfo.isXpos=0.05;
guiInfo.uiPos.FindSyn3DautoThrLin.DoSynapse3DthrLinChangeParam4=[guiInfo.isXpos guiInfo.isYpos guiInfo.isDX guiInfo.sliderLengthVert];
guiInfo.uiPos.FindSyn3DautoThrLin.DoSynapse3DthrLinChangeParam4Text=[guiInfo.isXpos guiInfo.isYpos-0.02 guiInfo.isDX 0.02];
guiInfo.uiPos.FindSyn3DautoThrLin.DoSynapse3DthrLinChangeParam4Str=[guiInfo.isXpos guiInfo.isYpos+guiInfo.sliderLengthVert guiInfo.isDX 0.02];

guiInfo.isXpos=0.01;
guiInfo.uiPos.FindSyn3DautoThrLin.DoSynapse3DthrLinChangeParam5=[guiInfo.isXpos guiInfo.isYpos guiInfo.isDX guiInfo.sliderLengthVert];
guiInfo.uiPos.FindSyn3DautoThrLin.DoSynapse3DthrLinChangeParam5Text=[guiInfo.isXpos guiInfo.isYpos-0.02 guiInfo.isDX 0.02];
guiInfo.uiPos.FindSyn3DautoThrLin.DoSynapse3DthrLinChangeParam5Str=[guiInfo.isXpos guiInfo.isYpos+guiInfo.sliderLengthVert guiInfo.isDX 0.02];

guiInfo.isXpos=0.05;
guiInfo.uiPos.FindSyn3DautoThrLin.DoSynapse3DthrLinChangeParam6=[guiInfo.isXpos guiInfo.isYpos guiInfo.isDX guiInfo.sliderLengthVert];
guiInfo.uiPos.FindSyn3DautoThrLin.DoSynapse3DthrLinChangeParam6Text=[guiInfo.isXpos guiInfo.isYpos-0.02 guiInfo.isDX 0.02];
guiInfo.uiPos.FindSyn3DautoThrLin.DoSynapse3DthrLinChangeParam6Str=[guiInfo.isXpos guiInfo.isYpos+guiInfo.sliderLengthVert guiInfo.isDX 0.02];

guiInfo.isYpos=0.85;
guiInfo.uiPos.FindSyn3DautoThrLin.DoSynapse3DthrLinStart=[0.03 0.95 0.06 0.03];
guiInfo.uiPos.FindSyn3DautoThrLin.DoSynapse3DthrLinStop=[0.03 0.90 0.06 0.03];
guiInfo.uiPos.FindSyn3DautoThrLin.DoSynapse3DthrLinMode=[0.1 guiInfo.isYpos 0.08 0.13];
guiInfo.uiPos.FindSyn3DautoThrLin.DoSynapse3DthrLinSource=[0.2 guiInfo.isYpos 0.08 0.13];
guiInfo.isYpos=0.85;guiInfo.sliderLengthVert=0.12;guiInfo.isDX=0.04;guiInfo.isXpos=0.3;
guiInfo.uiPos.FindSyn3DautoThrLin.DoSynapse3DthrLinSlice=[guiInfo.isXpos guiInfo.isYpos 0.03 guiInfo.sliderLengthVert];
guiInfo.uiPos.FindSyn3DautoThrLin.DoSynapse3DthrLinSliceText=[guiInfo.isXpos guiInfo.isYpos-0.02 0.03 0.02];
guiInfo.uiPos.FindSyn3DautoThrLin.DoSynapse3DthrLinSliceStr=[guiInfo.isXpos guiInfo.isYpos+guiInfo.sliderLengthVert 0.03 0.02];
guiInfo.uiPos.FindSyn3DautoThrLin.ListBoxResultSyn3DThrLin=[0.5 guiInfo.isYpos 0.2 0.13];
